#include "DHTMessage.h"

#include<boost/foreach.hpp>

namespace ariba {
namespace overlay {

vsznDefault(DHTMessage);

DHTMessage::DHTMessage() :
	ttl( 0 ),
	replace( false )
{}

DHTMessage::DHTMessage( const Data& key ) :
	ttl( 0 ),
	replace( false ),
	key( key.clone() )
{}

DHTMessage::DHTMessage( const Data& key, const Data& value ) :
	ttl( 0 ),
	replace( false ),
	key( key.clone() ),
	values(1, value.clone())
{}

DHTMessage::DHTMessage( const Data& key, const vector<Data>& values ) :
	ttl( 0 ),
	replace( false ),
	key( key.clone() )
{
	// preallocate enough room so we don't need to copy a lot
	this->values.reserve(values.size());
	BOOST_FOREACH(const Data value, values )
		this->values.push_back( value.clone() );
}

DHTMessage::~DHTMessage() {
	this->key.release();
	BOOST_FOREACH( Data& value, values ) value.release();
}

}}
