/*
 * endpoint.h
 *
 *  Created on: 26.03.2013
 *      Author: mario
 */

#ifndef ENDPOINT_HPP_
#define ENDPOINT_HPP_

// system
#include <stdint.h>
#include <string>

// boost
#include <boost/shared_ptr.hpp>

namespace ariba {
namespace addressing2 {

struct endpoint_category
{
    enum _ENDPOINT_CATEGORY {
        INVALID = 0,
        TCPIP = 1,
        BLUETOOTH = 2
    };
    
//    static const SEND_PRIORITY_INTERNAL OVERLAY = HIGHEST;
};
typedef endpoint_category::_ENDPOINT_CATEGORY ENDPOINT_CATEGORY;

struct endpoint_type
{
    enum _ENDPOINT_TYPE {
        INVALID = 0,
        TCPIPv4 = 1,
        TCPIPv6 = 2
    };
};
typedef endpoint_type::_ENDPOINT_TYPE ENDPOINT_TYPE;


class endpoint
{
public:
    virtual ~endpoint() {}
    
    virtual ENDPOINT_CATEGORY get_category() const = 0;
    virtual ENDPOINT_TYPE get_type() const = 0;
    
    /**
     * @return Human readable string representation of this endpoint.
     */
    virtual std::string to_string() const = 0;
    
    /**
     * Serializes this »endpoint« into a byte_array.
     * 
     * @param buffer: An array >= »endpoint::size()«
     * @return »endpoint::size()«
     */
    virtual size_t to_byte_array(uint8_t* buffer) const = 0;
    
    /**
     * @return Number of bytes:
     *   - read in »endpoint::endpoint(const uint8_t* byte_array);«
     *   - to be written in »endpoint::to_byte_array(uint8_t* buffer)«
     */
    virtual int size() const = 0;
};

typedef boost::shared_ptr<endpoint> EndpointPtr;
//typedef boost::shared_ptr<const endpoint> const_EndpointPtr;

// NOTE: An endpoint is designed as an unmutable object!

}} /* namespace ariba::addressing2 */
#endif /* ENDPOINT_HPP_ */
