#ifndef TRANSPORT_PROTOCOL_HPP_
#define TRANSPORT_PROTOCOL_HPP_

// ariba
#include "ariba/utility/addressing2/endpoint_set.hpp"
#include "ariba/utility/transport/messages/message.hpp"

// ariba interfaces
#include "transport_listener.hpp"

// namespace ariba::transport
namespace ariba {
namespace transport {

struct system_priority {
    enum SEND_PRIORITY_INTERNAL {
        HIGHEST = 0,
        HIGH = 1,
        ON_IDLE = 7
    };
    
    static const SEND_PRIORITY_INTERNAL OVERLAY = HIGHEST;
};



/**
 * TODO: Doc
 *
 * @author Sebastian Mies <mies@tm.uka.de>, Mario Hock
 */
class transport_protocol {
public:
    /// Allow deleting implementing classes by pointer
    virtual ~transport_protocol() {}
    
	virtual void start() = 0;
	virtual void stop() = 0;
	
	/**
	 * @returns whether this connection is assumed to be valid 
	 */
	virtual void send(
	        const addressing2::const_EndpointSetPtr endpoints,
	        reboost::message_t message,
	        uint8_t priority = system_priority::HIGH) = 0;
	
	/// @deprecated: Use terminate() from transport_connection instead
//	virtual void terminate( const address_v* remote ) = 0;
	
	virtual void register_listener( transport_listener* listener ) = 0;
};

}} // namespace ariba::transport

#endif /* TRANSPORT_PROTOCOL_HPP_ */
