#ifndef TRANSPORT_PEER_HPP_
#define TRANSPORT_PEER_HPP_

// ariba
#include "ariba/config.h"
#include "ariba/utility/logging/Logging.h"
#include "ariba/utility/addressing2/endpoint_set.hpp"

// ariba interfaces
#include "interfaces/transport_protocol.hpp"

// boost
#include <boost/shared_ptr.hpp>

// boost-adaption
//#include "rfcomm/bluetooth_rfcomm.hpp"


// namespace ariba::transport
namespace ariba {
namespace transport {

/**
 * This class allocates implementations of various transport
 * protocols and can send messages to an entire set of endpoints
 *
 * @author Sebastian Mies <mies@tm.uka.de>, Mario Hock
 */
class transport_peer :
    public transport_protocol
{
	use_logging_h(transport_peer);
	typedef boost::shared_ptr<transport_protocol> TransportProtocolPtr;
	
public:
	transport_peer();
	
	/**
	 * Adds endpoints on which ariba should listen ("server"-sockets)
	 * 
	 * @return An endpoint_set holding all active endpoints ariba is listening on.   
	 */
	addressing2::EndpointSetPtr add_listenOn_endpoints(addressing2::EndpointSetPtr endpoints);
	
	virtual ~transport_peer();
	virtual void start();
	virtual void stop();
	
	virtual void send(
	        const addressing2::const_EndpointSetPtr endpoints,
	        reboost::message_t message,
	        uint8_t priority = system_priority::OVERLAY);
		
	virtual void register_listener( transport_listener* listener );

	
private:
	addressing2::EndpointSetPtr local;
	std::vector<TransportProtocolPtr> transport_streams;
};

}} // namespace ariba::transport

#endif /* TRANSPORT_PEER_HPP_ */
