#ifndef TRANSPORT_CONNECTION_HPP
#define TRANSPORT_CONNECTION_HPP

// ariba
#include "ariba/utility/transport/messages/message.hpp"
#include "ariba/utility/addressing2/endpoint.hpp"

#include <vector>
#include <boost/shared_ptr.hpp>

namespace ariba {

// forward declaration
namespace utility {
    class LinkID;
}


namespace transport {

class transport_connection
{
public:
    typedef boost::shared_ptr<transport_connection> sptr;
    
    /// Allow deleting implementing classes by pointer
    virtual ~transport_connection() {}
    
    virtual bool send(reboost::message_t message, uint8_t priority = 1) = 0;
    
    virtual ariba::addressing2::EndpointPtr getLocalEndpoint() = 0;
    virtual ariba::addressing2::EndpointPtr getRemoteEndpoint() = 0;

    
    /**
     * Tells this transport_connection, that it's used by the given
     * communication link.
     */
    virtual void register_communication_link(ariba::utility::LinkID* link) = 0;

    /**
     * Tells this transport_connection, that it's no longer used by the given
     * communication link.
     * 
     * A transport_connection may terminate itself, when it's no longer used by
     * any communication link.
     */
    virtual void unregister_communication_link(ariba::utility::LinkID* link) = 0;
    
    /**
     * @return A vector of all registered communication links.
     */
    virtual std::vector<ariba::utility::LinkID*> get_communication_links() = 0;
    
    virtual void terminate() = 0;
};

} /* namespace transport */
} /* namespace ariba */
#endif /* TRANSPORT_CONNECTION_HPP */
