#include "Udp.h"

using namespace std;

udp_server::~udp_server()
{
}

void udp_server::listen_on(uint16_t port)
{
    std::cout << "[UDP] listening on port: " << port << std::endl;
    
    socket_.open(udp::v4());
    socket_.bind(udp::endpoint(udp::v4(), port));
    start_receive();
}

void udp_server::connect_to(uint16_t port)
{
    std::cout << "[UDP] connecting to port: " << port << " (on localhost)" << std::endl;

    remote_endpoint_ = udp::endpoint(boost::asio::ip::address::from_string("127.0.0.1"), port);
    
    socket_.open(udp::v4());
    socket_.connect(remote_endpoint_);
    start_receive();
}


/* MessageSenderInterface */
void udp_server::SendMessage(reboost::shared_buffer_t msg)
{
    cout << "[UDP] sending " << msg.size() << " bytes to " << remote_endpoint_ << endl;
    
    // send over udp
    socket_.async_send_to(
        boost::asio::buffer(msg.data(), msg.size()),
        remote_endpoint_,
        boost::bind(&udp_server::handle_send, this, msg,
            boost::asio::placeholders::error,
            boost::asio::placeholders::bytes_transferred));
}
void udp_server::SendMessage(reboost::message_t msg)
{
    reboost::shared_buffer_t buf = msg.linearize();
    this->SendMessage(buf);
}



/* asio udp */
void udp_server::start_receive()
{
    recv_buffer_ = reboost::shared_buffer_t(3000);
    
    socket_.async_receive_from(
        boost::asio::buffer(recv_buffer_.mutable_data(), recv_buffer_.size()),
        remote_endpoint_,
        boost::bind(&udp_server::handle_receive, this,
        boost::asio::placeholders::error,
        boost::asio::placeholders::bytes_transferred));
}

void udp_server::handle_receive(const boost::system::error_code& error, std::size_t bytes_transferred)
{
    if (!error || error == boost::asio::error::message_size)
    {
        cout << "[UDP] received " << bytes_transferred << " bytes from " << remote_endpoint_ << endl;

        // send sub-buffer trough tunnel
        send_via_ariba( recv_buffer_(0, bytes_transferred) );

        // wait for further messages...
        start_receive();
    }
}

void udp_server::handle_send(reboost::shared_buffer_t msg, const boost::system::error_code& , std::size_t )
{
    // empty
}


/// forward data over ariba
void udp_server::send_via_ariba(reboost::shared_buffer_t buffer)
{
    tunnel.SendMessage(buffer);
}
