#include "gtest/gtest.h"
#include "ariba/utility/system/SystemQueue.h"

using namespace ::testing;
using namespace ariba::utility;


/**
 *  Tests if the SystemQueue is initialized empty and not running.
 */
TEST(SystemQueue, Instantiation)
{
    SystemQueue& sysq = SystemQueue::instance();
    
    EXPECT_FALSE( sysq.isRunning() );
    EXPECT_TRUE( sysq.isEmpty() );
}


/**
 *  Tests whether calling the SystemQueue::instance() always returns the same object.
 * 
 *  NOTE: This is an easy case, since this is the same compile unit..
 *    But can't hurt to test it anyway.
 */
TEST(SystemQueue, Singleton)
{
    SystemQueue& sysq = SystemQueue::instance();
    SystemQueue& sysq2 = SystemQueue::instance();

//     cout << &sysq << endl;
    ASSERT_TRUE( &sysq == &sysq2 );
}


