// [Licence]
// The Ariba-Underlay Copyright
//
// Copyright (c) 2008-2009, Institute of Telematics, Universität Karlsruhe (TH)
//
// Institute of Telematics
// Universität Karlsruhe (TH)
// Zirkel 2, 76128 Karlsruhe
// Germany
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
// 1. Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the
// documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE INSTITUTE OF TELEMATICS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE ARIBA PROJECT OR
// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
// PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
// LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
// NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// The views and conclusions contained in the software and documentation
// are those of the authors and should not be interpreted as representing
// official policies, either expressed or implied, of the Institute of
// Telematics.
// [Licence]

#ifndef __OVERLAY_INTERFACE_H
#define __OVERLAY_INTERFACE_H

#include "ariba/communication/EndpointDescriptor.h"
#include "ariba/interface/ServiceInterface.h"
#include "ariba/overlay/modules/OverlayStructureEvents.h"
#include "ariba/utility/types/NodeID.h"
#include "ariba/utility/types/ServiceID.h"

using ariba::communication::EndpointDescriptor;
using ariba::interface::ServiceInterface;
using ariba::overlay::OverlayStructureEvents;
using ariba::utility::NodeID;
using ariba::utility::ServiceID;

namespace ariba {
namespace overlay {

class BaseOverlay;

class OverlayInterface : public ServiceInterface {
public:
	OverlayInterface(
		BaseOverlay& _baseoverlay,
		const NodeID& _nodeid,
		OverlayStructureEvents* _eventsReceiver
	);

	virtual ~OverlayInterface();

	typedef vector<NodeID> NodeList;

	virtual void createOverlay() = 0;
	virtual void deleteOverlay() = 0;

	virtual void joinOverlay( const EndpointDescriptor& bootstrapEp = EndpointDescriptor::UNSPECIFIED) = 0;
	virtual void leaveOverlay() = 0;

	virtual const EndpointDescriptor& resolveNode( const NodeID& node ) = 0;
	virtual void routeMessage( const NodeID& destnode, Message* msg ) = 0;

	virtual NodeList getKnownNodes() const = 0;

protected:
	BaseOverlay& baseoverlay;
	const NodeID& nodeid;
	OverlayStructureEvents* eventsReceiver;
	static ServiceID OVERLAY_SERVICE_ID;
};

}} // namespace ariba, overlay

#endif // __OVERLAY_INTERFACE_H
