// [Licence]
// The Ariba-Underlay Copyright
//
// Copyright (c) 2008-2009, Institute of Telematics, Universität Karlsruhe (TH)
//
// Institute of Telematics
// Universität Karlsruhe (TH)
// Zirkel 2, 76128 Karlsruhe
// Germany
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
// 1. Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the
// documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE INSTITUTE OF TELEMATICS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE ARIBA PROJECT OR
// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
// PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
// LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
// NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// The views and conclusions contained in the software and documentation
// are those of the authors and should not be interpreted as representing
// official policies, either expressed or implied, of the Institute of
// Telematics.
// [Licence]

#ifndef TRANSPORTLOCATOR_H_
#define TRANSPORTLOCATOR_H_

#include <vector>
#include "boost/cstdint.hpp"
#include "ariba/utility/types/Locator.h"
#include "../network/NetworkLocator.h"

using ariba::utility::Locator;
using std::vector;

#include "ariba/communication/modules/_namespace.h"
NAMESPACE_BEGIN;

class TransportLocator : public Locator {
public:
	typedef uint16_t prot_t;

private:
	prot_t type;
	vector<NetworkLocator*> netLocators;

public:
	TransportLocator();
	virtual ~TransportLocator();

	inline prot_t getType() const {
		return type;
	}

	inline void setType( prot_t type ) {
		this->type = type;
	}

	inline const vector<NetworkLocator*> getNetworkLocators() const {
		return netLocators;
	}

	virtual bool operator==( TransportLocator* locator ) const = 0;
};

NAMESPACE_END;

#endif /* TRANSPORTLOCATOR_H_ */
