// [Licence]
// The Ariba-Underlay Copyright
//
// Copyright (c) 2008-2009, Institute of Telematics, Universität Karlsruhe (TH)
//
// Institute of Telematics
// Universität Karlsruhe (TH)
// Zirkel 2, 76128 Karlsruhe
// Germany
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
// 1. Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the
// documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE INSTITUTE OF TELEMATICS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE ARIBA PROJECT OR
// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
// PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
// LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
// NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// The views and conclusions contained in the software and documentation
// are those of the authors and should not be interpreted as representing
// official policies, either expressed or implied, of the Institute of
// Telematics.
// [Licence]

#ifndef UNDERLAYABSTRACTION_H_
#define UNDERLAYABSTRACTION_H_

#include <string>
#include "ariba/utility/types/OverlayParameterSet.h"
#include "ariba/utility/types/SecurityParameterSet.h"
#include "ariba/utility/types/QoSParameterSet.h"
#include "ariba/utility/types/SpoVNetID.h"
#include "ariba/interface/AribaContext.h"
#include "ariba/communication/BaseCommunication.h"
#include "ariba/overlay/BaseOverlay.h"

using std::string;
using ariba::utility::OverlayParameterSet;
using ariba::utility::SecurityParameterSet;
using ariba::utility::QoSParameterSet;
using ariba::utility::SpoVNetID;
using ariba::interface::AribaContext;
using ariba::communication::BaseCommunication;
using ariba::overlay::BaseOverlay;

namespace ariba {
namespace interface {

#define ARIBA_DEFAULT_PORT 0xa1ba

class UnderlayAbstraction {
	use_logging_h( UnderlayAbstraction );
public:
	UnderlayAbstraction();
	virtual ~UnderlayAbstraction();

	AribaContext* createSpoVNet(
		const SpoVNetID& spovnetid,
		const NodeID& nodeid = NodeID::UNSPECIFIED,
		const NetworkLocator* locallocator = NULL,
		const uint16_t localport = ARIBA_DEFAULT_PORT,
		const OverlayParameterSet& param = OverlayParameterSet::DEFAULT,
		const SecurityParameterSet& sec  = SecurityParameterSet::DEFAULT,
		const QoSParameterSet& qos = QoSParameterSet::DEFAULT
	);

	void destroySpoVNet( AribaContext* ctx );

	AribaContext* joinSpoVNet(
		const SpoVNetID& spovnetid,
		const EndpointDescriptor& bootstrapnode,
		const NodeID& nodeid = NodeID::UNSPECIFIED,
		const NetworkLocator* locallocator = NULL,
		const uint16_t localport = ARIBA_DEFAULT_PORT
	);

	void leaveSpoVNet( AribaContext* ctx );

protected:
	AribaContext* createNode(
		const SpoVNetID& spovnetid,
		const NodeID& nodeid,
		const NetworkLocator* locallocator,
		const uint16_t localport
	);

private:
	BaseCommunication* basecomm;

};

}} //namespace ariba, interface

#endif //UNDERLAYABSTRACTION_H_
