
#include "StringFormat.h"

#include "boost/xpressive/xpressive.hpp"

using namespace boost::xpressive;

// regex: string
const sregex StringFormat::rstring = '"' >> keep(*~(boost::xpressive::set = '"'))
		>> '"';

// regex: base64 encoding
const sregex StringFormat::rbase64 = '!' >> +(range('a', 'z') | range('A', 'Z')
		| range('0', '9') | '/' | '+') >> *(boost::xpressive::set = '=');

// regex: raw alphabet
const sregex StringFormat::rchars = +(range('a', 'z') | range('A', 'Z'));

// regex: integer
const sregex StringFormat::rint = '0' | (range('1', '9') >> !(range('0', '9')));

// regex: binary label
const sregex StringFormat::rlabel = rchars | rstring | rbase64;

// regex: dot separated identifier
const sregex StringFormat::rid = rlabel >> *('.' >> rlabel) >> *('.' >> rint);

// regex: "leaf" data
const sregex StringFormat::rdata = !(boost::xpressive::set = '!') >> '{'
		>> *(keep(+~(boost::xpressive::set = '{', '}')) | by_ref(rdata))
		>> '}';

// regex: fields
const sregex StringFormat::rfield_label = rlabel >> '=';
const sregex StringFormat::rfield = !rfield_label >> (rid | rdata);
const sregex StringFormat::rfields = '(' >> rfield >> *(',' >> rfield) >> ')';

// regex: objects
const sregex StringFormat::robject_data = (rdata | rfields);
const sregex StringFormat::robject = rid >> robject_data;
const sregex StringFormat::robjects = robject >> *(',' >> robject);
