
#ifndef STRINGFORMAT_H_
#define STRINGFORMAT_H_

#include "boost/xpressive/xpressive.hpp"

using boost::xpressive::sregex;

/**
 * This class defines some regular expressions ...
 *
 * @author Sebastian Mies
 */
class StringFormat {
public:
	// regex: string
	static const sregex rstring;

	// regex: base64 encoding
	static const sregex rbase64;

	// regex: raw alphabet
	static const sregex rchars;

	// regex: integer
	static const sregex rint;

	// regex: binary label
	static const sregex rlabel;

	// regex: dot separated identifier
	static const sregex rid;

	// regex: "leaf" data
	static const sregex rdata;

	// regex: fields
	static const sregex rfield_label;
	static const sregex rfield;
	static const sregex rfields;

	// regex: objects
	static const sregex robject_data;
	static const sregex robject;
	static const sregex robjects;
};

#endif /* STRINGFORMAT_H_ */
