// [Licence]
// The Ariba-Underlay Copyright
//
// Copyright (c) 2008-2009, Institute of Telematics, Universität Karlsruhe (TH)
//
// Institute of Telematics
// Universität Karlsruhe (TH)
// Zirkel 2, 76128 Karlsruhe
// Germany
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
// 1. Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the
// documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE INSTITUTE OF TELEMATICS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE ARIBA PROJECT OR
// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
// PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
// LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
// NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// The views and conclusions contained in the software and documentation
// are those of the authors and should not be interpreted as representing
// official policies, either expressed or implied, of the Institute of
// Telematics.
// [Licence]

#ifndef TCPTRANSPORT_H_
#define TCPTRANSPORT_H_

// kill protlib logging
#define _NO_LOGGING

#include "ariba/utility/logging/Logging.h"
#include "ariba/utility/messages.h"
#include "ariba/utility/types/Address.h"
#include "ariba/utility/misc/Helper.h"
#include "ariba/utility/system/SystemEventListener.h"
#include "ariba/utility/system/SystemEvent.h"
#include "ariba/utility/system/SystemEventType.h"
#include "ariba/communication/modules/network/ip/IPv4Locator.h"
#include "ariba/communication/modules/transport/TransportProtocol.h"
#include "ariba/communication/modules/transport/protlib/network_message.h"
#include "ariba/communication/modules/transport/protlib/protlib_types.h"
#include "ariba/communication/modules/transport/protlib/threads.h"
#include "ariba/communication/modules/transport/protlib/tp_over_tcp.h"

#include "ariba/communication/modules/_namespace.h"
NAMESPACE_BEGIN;

using namespace protlib;
using ariba::utility::Address;
using ariba::utility::seqnum_t;
using ariba::utility::Message;
using ariba::utility::SystemEventListener;
using ariba::utility::SystemEvent;
using ariba::utility::SystemEventType;
using ariba::communication::IPv4Locator;

class TCPTransport : public TransportProtocol, public SystemEventListener {

	use_logging_h(TCPTransport);

private:
	port_t port;
	volatile bool done;
	volatile bool running;
	pthread_t tpreceivethread;
	ThreadStarter<TPoverTCP, TPoverTCPParam>* tpthread;

	static void* receiverThread( void* ptp );
	static bool  getMessageLength( NetMsg& m, uint32& clen_bytes );

public:
	TCPTransport( port_t port );
	virtual ~TCPTransport();

	/** @see TransportProtocol.h */
	virtual void start();

	/** @see TransportProtocol.h */
	virtual void stop();

	/** @see TransportProtocol.h */
	virtual TransportLocator::prot_t getId();

	/** @see TransportProtocol.h */
	virtual const vector<TransportLocator*> getLocators();

	/* @see MessageSender */
	virtual seqnum_t sendMessage( const Message* message );

	/** @see TransportProtocol.h */
	virtual void terminate(const NetworkLocator* local, const NetworkLocator* remote);

protected:
	virtual void handleSystemEvent( const SystemEvent& event );

};

NAMESPACE_END;

#endif /* TCPTRANSPORT_H_ */
