// [License]
// The Ariba-Underlay Copyright
//
// Copyright (c) 2008-2009, Institute of Telematics, Universität Karlsruhe (TH)
//
// Institute of Telematics
// Universität Karlsruhe (TH)
// Zirkel 2, 76128 Karlsruhe
// Germany
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
// 1. Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the
// documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE INSTITUTE OF TELEMATICS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE ARIBA PROJECT OR
// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
// PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
// LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
// NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// The views and conclusions contained in the software and documentation
// are those of the authors and should not be interpreted as representing
// official policies, either expressed or implied, of the Institute of
// Telematics.
// [License]

#include "IPv4Locator.h"

namespace ariba {
namespace communication {

vsznDefault(IPv4Locator);

IPv4Locator IPv4Locator::ANY        = IPv4Locator::fromString("0.0.0.0");
IPv4Locator IPv4Locator::LOCALHOST  = IPv4Locator::fromString("127.0.0.1");
IPv4Locator IPv4Locator::BROADCAST  = IPv4Locator::fromString("255.255.255.255");

IPv4Locator::IPv4Locator() {
	this->port = 0;
}

IPv4Locator::~IPv4Locator() {
}

bool IPv4Locator::operator==(const NetworkLocator& rh) const {

	IPv4Locator* ipv4Rh = dynamic_cast<IPv4Locator*>(const_cast<NetworkLocator*>(&rh));
	if( ipv4Rh == NULL ) return false;

	return (this->ipv4Address == ipv4Rh->ipv4Address) /*&& (this->port == ipv4Rh->port)*/;
}

bool IPv4Locator::operator!=(const NetworkLocator& rh) const {
	return (!operator==(rh));
}

IPv4Locator IPv4Locator::fromString(string addr){

	IPv4Locator locator;
	string::size_type p = addr.find(':');

	string port = "";
	if (p != string::npos) {
		port = addr.substr(p+1);
		addr = addr.substr(0,p);
		std::istringstream i(port);
		i >> locator.port;
	}
	locator.ipv4Address = boost::asio::ip::address_v4::from_string( addr );

	return locator;
}

string IPv4Locator::toString() const {
	std::ostringstream o;
	o << ipv4Address.to_string();
	if (port!=0) o << ":" << port;
	return o.str();
}

IPv4Locator::IPv4Locator(const IPv4Locator& rh) : ipv4Address(rh.ipv4Address), port(rh.port){
}

}} // namespace ariba, communication
