// [License]
// The Ariba-Underlay Copyright
//
// Copyright (c) 2008-2009, Institute of Telematics, Universität Karlsruhe (TH)
//
// Institute of Telematics
// Universität Karlsruhe (TH)
// Zirkel 2, 76128 Karlsruhe
// Germany
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
// 1. Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the
// documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE INSTITUTE OF TELEMATICS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE ARIBA PROJECT OR
// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
// PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
// LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
// NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// The views and conclusions contained in the software and documentation
// are those of the authors and should not be interpreted as representing
// official policies, either expressed or implied, of the Institute of
// Telematics.
// [License]

#ifndef __CHORD_MESSAGE_H
#define __CHORD_MESSAGE_H

#include "ariba/utility/messages.h"
#include "ariba/utility/serialization.h"
#include "ariba/Identifiers.h"

using ariba::utility::Message;

namespace ariba {
namespace overlay {

using_serialization
;

class ChordMessage: public Message { VSERIALIZEABLE
public:
	enum type_ {
		invalid = 0, ///< invalid message
		route = 1, ///< route message with payload
		discovery = 2, ///< discover neighbors of a destination node
		leave = 3, ///< leave message
	};

	inline ChordMessage( const ChordMessage& msg ) {
		this->type = msg.type;
		this->hop_count = msg.hop_count;
		this->source = msg.source;
		this->destination = msg.destination;
	}

	inline explicit ChordMessage(type_ type = invalid,
			const NodeID& source = NodeID::UNSPECIFIED,
			const NodeID& destination = NodeID::UNSPECIFIED) :
		type((uint8_t) type), source(source), destination(destination) {
	}

	virtual ~ChordMessage();

	inline uint8_t getHopCount() const {
		return hop_count;
	}

	inline void setHopCount( uint8_t hop_count ) {
		this->hop_count = hop_count;
	}

	inline type_ getType() const {
		return (type_) this->type;
	}

	const NodeID& getSource() const {
		return source;
	}

	inline const NodeID& getDestination() const {
		return destination;
	}

private:
	uint8_t type;
	uint8_t hop_count;
	NodeID source, destination;
};

}} // ariba::overlay

sznBeginDefault( ariba::overlay::ChordMessage, X ){
	X && type && hop_count && &source && &destination && Payload();
}sznEnd();

#endif // __CHORD_MESSAGE_H
