#include <string>
#include "ariba/utility/system/StartupWrapper.h"
#include "PingPong.h"

using std::string;
using ariba::utility::StartupWrapper;
using ariba::application::pingpong::PingPong;

//*************************************************

#include <iostream>
#include <boost/cstdint.hpp>

using std::cout;
using std::endl;

void debugging(){

	cout << "int" << " - \t \t" << sizeof(int) << endl;
	cout << "unsigned int" << " - \t \t" << sizeof(unsigned int) << endl;
	cout << "long" << " - \t \t" << sizeof(long) << endl;
	cout << "unsigned long" << " - \t \t" << sizeof(unsigned long) << endl;
	cout << "char" << " - \t \t" << sizeof(char) << endl;
	cout << "unsigned char" << " - \t \t" << sizeof(unsigned char) << endl;
	cout << "short" << " - \t \t" << sizeof(short) << endl;
	cout << "unsigned short" << " - \t \t" << sizeof(unsigned short) << endl;
	cout << "uint16_t" << " - \t \t" << sizeof(uint16_t) << endl;
	cout << "uint8_t" << " - \t \t" << sizeof(uint8_t) << endl;
	cout << "uint32_t" << " - \t \t" << sizeof(uint32_t) << endl;
	cout << "int8_t" << " - \t \t" << sizeof(int8_t) << endl;
	cout << "int16_t" << " - \t \t" << sizeof(int16_t) << endl;
	cout << "int32_t" << " - \t \t" << sizeof(int32_t) << endl;
	cout << "boost::uint16_t" << " - \t \t" << sizeof(boost::uint16_t) << endl;
	cout << "boost::uint8_t" << " - \t \t" << sizeof(boost::uint8_t) << endl;
	cout << "boost::uint32_t" << " - \t \t" << sizeof(boost::uint32_t) << endl;
	cout << "boost::int8_t" << " - \t \t" << sizeof(boost::int8_t) << endl;
	cout << "boost::int16_t" << " - \t \t" << sizeof(boost::int16_t) << endl;
	cout << "boost::int32_t" << " - \t \t" << sizeof(boost::int32_t) << endl;

}

//*************************************************


int main( int argc, char** argv ) {

	debugging();
	return 0;

	// get config file
	string config = "../etc/settings.cnf";
	if (argc >= 2) config = argv[1];

	StartupWrapper::initConfig( config );
	StartupWrapper::startSystem();

	// this will do the main functionality and block
	PingPong ping;
	StartupWrapper::startup(&ping);

	// --> we will run blocking until <enter> is hit

	StartupWrapper::shutdown(&ping);
	StartupWrapper::stopSystem();

	return 0;
}
