// [License]
// The Ariba-Underlay Copyright
//
// Copyright (c) 2008-2009, Institute of Telematics, Universität Karlsruhe (TH)
//
// Institute of Telematics
// Universität Karlsruhe (TH)
// Zirkel 2, 76128 Karlsruhe
// Germany
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
// 1. Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the
// documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE INSTITUTE OF TELEMATICS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE ARIBA PROJECT OR
// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
// PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
// LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
// NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// The views and conclusions contained in the software and documentation
// are those of the authors and should not be interpreted as representing
// official policies, either expressed or implied, of the Institute of
// Telematics.
// [License]

#ifndef OVERLAY_MSG_H__
#define OVERLAY_MSG_H__

#include <boost/cstdint.hpp>
#include "ariba/utility/messages.h"
#include "ariba/utility/serialization.h"
#include "ariba/utility/types/ServiceID.h"
#include "ariba/utility/types/NodeID.h"
#include "ariba/utility/types/LinkID.h"

using ariba::utility::LinkID;
using ariba::utility::NodeID;
using ariba::utility::ServiceID;
using ariba::utility::Message;

namespace ariba {
namespace overlay {

using_serialization;

class OverlayMsg : public Message {
	VSERIALIZEABLE;
public:

	typedef enum _OverlayMessageType {
		OverlayMessageTypeInvalid     = 0, // invalid type (no encapsulated messages)
		OverlayMessageTypeData        = 1, // message contains data for higher layers
		OverlayMessageTypeJoinRequest = 2, // spovnet join request
		OverlayMessageTypeJoinReply   = 3, // spovnet join reply
		OverlayMessageTypeUpdate      = 4, // update message for link association
		OverlayMessageTypeBye         = 5, // spovnet leave (no encapsulated messages)
		OverlayMessageTypeLinkRequest = 6, // link request (sent over the overlay)
	} OverlayMessageType;

	OverlayMsg(
		OverlayMessageType _type       = OverlayMessageTypeInvalid,
		const ServiceID    _service    = ServiceID::UNSPECIFIED,
		const NodeID       _sourceNode = NodeID::UNSPECIFIED
	);

	OverlayMsg(
		OverlayMessageType _type,
		const NodeID       _sourceNode
	);

	virtual ~OverlayMsg();

	bool isType(OverlayMessageType _type);
	OverlayMessageType getType();
	const ServiceID& getService();
	const NodeID& getSourceNode();

private:
	uint16_t type; //TODO: was uint8_t
	ServiceID service;
	NodeID sourceNode;
};

}} // ariba::overlay

sznBeginDefault( ariba::overlay::OverlayMsg, X ) {
	X && type && &service && &sourceNode && Payload();
} sznEnd();

#endif // OVERLAY_MSG_H__
