// [License]
// The Ariba-Underlay Copyright
//
// Copyright (c) 2008-2009, Institute of Telematics, Universität Karlsruhe (TH)
//
// Institute of Telematics
// Universität Karlsruhe (TH)
// Zirkel 2, 76128 Karlsruhe
// Germany
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
// 1. Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the
// documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE INSTITUTE OF TELEMATICS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE INSTITUTE OF TELEMATICS OR
// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
// PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
// LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
// NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// The views and conclusions contained in the software and documentation
// are those of the authors and should not be interpreted as representing
// official policies, either expressed or implied, of the Institute of
// Telematics.
// [License]

#include "SideportListener.h"

#include "ariba/overlay/BaseOverlay.h"

namespace ariba {

SideportListener SideportListener::DEFAULT;

SideportListener::SideportListener() : overlay(NULL) {
}

SideportListener::~SideportListener(){
}

string SideportListener::getEndpointDescription( const LinkID& link ) const {
	if( overlay == NULL ) return "";
	return overlay->getEndpointDescriptor(link).toString();
}

string SideportListener::getEndpointDescription( const NodeID& node ) const {
	if( overlay == NULL ) return "";
	return overlay->getEndpointDescriptor(node).toString();
}

const NodeID& SideportListener::getNodeID( const LinkID& link ) const {
	if( overlay == NULL ) return NodeID::UNSPECIFIED;
	return overlay->getNodeID(link);
}

vector<LinkID> SideportListener::getLinkIDs( const NodeID& node ) const {
	if( overlay == NULL ) return vector<LinkID>();
	return overlay->getLinkIDs( node );
}

//******************************************************
//
// JUST EXPERIMENTAL WITH RANDOM RESULTS
//

// 0 = normal node    --> directly accessible
// 1 = relaying node  --> node that is relaying for us (must also be 0)
// 2 = relayed node   --> node that we cannot access directly
static map<NodeID,short> relayingnodes;

bool SideportListener::isRelayingNode(const NodeID& node){

	map<NodeID,short>::iterator i = relayingnodes.find(node);
	if(i != relayingnodes.end()) return (i->second == 1);

	relayingnodes.insert( std::make_pair( node, rand()%3 ) );
}

bool SideportListener::isRelayedNode(const NodeID& node){

	map<NodeID,short>::iterator i = relayingnodes.find(node);
	if(i != relayingnodes.end()) return (i->second == 2);

	relayingnodes.insert( std::make_pair( node, rand()%3 ) );
}

//
//
//******************************************************

void SideportListener::configure( overlay::BaseOverlay* _overlay ) {
	overlay = _overlay;
}

void SideportListener::onLinkUp(const LinkID& lnk, const NodeID& local, const NodeID& remote, const SpoVNetID& spovnet){
}

void SideportListener::onLinkDown(const LinkID& lnk, const NodeID& local, const NodeID& remote, const SpoVNetID& spovnet){
}

void SideportListener::onLinkChanged(const LinkID& lnk, const NodeID& local, const NodeID& remote, const SpoVNetID& spovnet){
}

void SideportListener::onLinkFail(const LinkID& lnk, const NodeID& local, const NodeID& remote, const SpoVNetID& spovnet){
}

} // namespace ariba
