#ifndef ARIBA_OVERLAY_LINKREQUEST_H_
#define ARIBA_OVERLAY_LINKREQUEST_H_

#include "ariba/utility/messages.h"
#include "ariba/utility/serialization.h"
#include "ariba/communication/EndpointDescriptor.h"

using ariba::communication::EndpointDescriptor;

namespace ariba {
namespace overlay {

using_serialization;

using ariba::utility::Message;

/**
 * This message is sent to another overlay node to request a new link.
 *
 * @author Sebastian Mies <mies@tm.uka.de>
 */
class LinkRequest : public Message {
	VSERIALIZEABLE;
private:
	bool free_endpoint_;
	uint8_t flags;
	uint32_t nonce;
	const EndpointDescriptor* endpoint;
	LinkID remoteLinkId;
	NodeID relay;

public:
	LinkRequest() {

	}

	LinkRequest( uint32_t nonce, const EndpointDescriptor* endpoint,
			bool reply = false, const LinkID& remoteLinkId = LinkID::UNSPECIFIED,
			const NodeID& relay = NodeID::UNSPECIFIED ) :
			flags(reply&1), nonce(nonce), endpoint(endpoint), remoteLinkId(remoteLinkId), relay(relay) {
	}

	virtual ~LinkRequest();

	const EndpointDescriptor* getEndpoint() const {
		return endpoint;
	}

	const LinkID& getRemoteLinkId() const {
		return remoteLinkId;
	}

	const NodeID& getRelay() const {
		return relay;
	}

	bool isReply() const {
		return flags & 1;
	}

	uint32_t getNonce() const {
		return nonce;
	}
};

}} // ariba::overlay

sznBeginDefault( ariba::overlay::LinkRequest, X ) {
	if (X.isDeserializer()) endpoint = new EndpointDescriptor();
	X && flags && nonce;
	X && const_cast<EndpointDescriptor*>(endpoint);
	X && &relay && &remoteLinkId;
} sznEnd();

#endif /* ARIBA_OVERLAY_LINKREQUEST_H_ */
