#ifndef RELAYMESSAGE_H_
#define RELAYMESSAGE_H_

#include "ariba/utility/messages.h"
#include "ariba/utility/serialization.h"
#include "ariba/communication/EndpointDescriptor.h"

using ariba::communication::EndpointDescriptor;

namespace ariba {
namespace overlay {

using_serialization;

using ariba::utility::Message;

/**
 * This message is sent to another overlay node to request a new link.
 *
 * @author Sebastian Mies <mies@tm.uka.de>
 */
class RelayMessage : public Message {
	VSERIALIZEABLE;
private:
	uint8_t type;
	NodeID relayNode;
	NodeID destNode;
	LinkID destLink;

public:
	enum type_ {
		typeInvalid = 0,
		typeInform = 1,
		typeRoute = 2
	};

	/// contructs a unspecified relay message
	RelayMessage() :
		type(typeInvalid), relayNode(NodeID::UNSPECIFIED), destNode(NodeID::UNSPECIFIED) {
	}

	RelayMessage( type_ type, const NodeID& relayNode, const NodeID& destNode, const LinkID& destLink = LinkID::UNSPECIFIED ) :
		type(type), relayNode(relayNode), destNode(destNode), destLink(destLink) {
	}

	~RelayMessage();

	/// returns the type of this message
	type_ getType() const {
		return (type_)type;
	}

	/// sets the type of this message
	void setType( type_ type ) {
		this->type = type;
	}

	/// returns the remote (destination) node id
	const NodeID& getDestNode() const {
		return destNode;
	}

	const LinkID& getDestLink() const {
		return destLink;
	}

	/// returns the relay node for the destination
	const NodeID& getRelayNode() const {
		return relayNode;
	}
};

}} // ariba::overlay

sznBeginDefault( ariba::overlay::RelayMessage, X ) {
	X && type && &relayNode && &destNode && &destLink && Payload();
} sznEnd();

#endif /* RELAYMESSAGE_H_ */
