// [License]
// The Ariba-Underlay Copyright
//
// Copyright (c) 2008-2009, Institute of Telematics, Universität Karlsruhe (TH)
//
// Institute of Telematics
// Universität Karlsruhe (TH)
// Zirkel 2, 76128 Karlsruhe
// Germany
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
// 1. Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the
// documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE INSTITUTE OF TELEMATICS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE ARIBA PROJECT OR
// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
// PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
// LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
// NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// The views and conclusions contained in the software and documentation
// are those of the authors and should not be interpreted as representing
// official policies, either expressed or implied, of the Institute of
// Telematics.
// [License]

#include "AddressInformation.h"

#include <ifaddrs.h>

#include <boost/asio/ip/address.hpp>
#include <boost/asio/ip/address_v4.hpp>

namespace ariba {
namespace communication {

using namespace ariba::addressing;

AddressInformation::AddressInformation(){
}

AddressInformation::~AddressInformation(){
}

AddressList AddressInformation::getAddresses(const NetworkInterface& interface){

	AddressList retlist;

	// gather transport addresses
	struct ifaddrs* ifap;
	getifaddrs( &ifap );

	for( struct ifaddrs* p = ifap; p != NULL; p=p->ifa_next ){

		// no name set? ->continue
		if( interface.name.compare(string(p->ifa_name)) != 0 ) continue;

		// handle IPv4 entry
		struct sockaddr* addr = p->ifa_addr;
		if( addr->sa_family == AF_INET ) {
			// get address
			const struct sockaddr_in& ipv4 = (const struct sockaddr_in&)*addr;
			boost::asio::ip::address_v4::bytes_type bytes;
			for( int i=0; i<4; i++ )
				bytes[i] = (ipv4.sin_addr.s_addr >> (24-i*8)) & 0xff;

			// add ipv4 address
			boost::asio::ip::address boost_addr = boost::asio::ip::address_v4( bytes );
			retlist.push_back( vcapsule<address_v>( ip_address(boost_addr) ) );
		}
	}

	freeifaddrs( ifap );

	return retlist;
}

}} // namespace ariba, communication
