#ifndef ADDRESSDISCOVERY_HPP_
#define ADDRESSDISCOVERY_HPP_

#include "ariba/utility/addressing/addressing.hpp"

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <sys/socket.h>

#include <arpa/inet.h>

#include <netinet/in.h>

#include <net/if.h>

#include <ifaddrs.h>

#include <bluetooth/bluetooth.h>
#include <bluetooth/hci.h>
#include <bluetooth/hci_lib.h>

using namespace ariba::addressing;

mac_address getMacFromIF( const char* name ) {
	int s;
	struct ifreq buffer;
	s = socket(PF_INET, SOCK_DGRAM, 0);
	memset(&buffer, 0x00, sizeof(buffer));
	strcpy(buffer.ifr_name, name);
	ioctl(s, SIOCGIFHWADDR, &buffer);
	close(s);
	mac_address addr;
	addr.assign( (uint8_t*)buffer.ifr_hwaddr.sa_data, 6 );
	return addr;
}


int dev_info(int s, int dev_id, long arg) {
	endpoint_set* set = (endpoint_set*)arg;
	struct hci_dev_info di;
	di.dev_id = dev_id;
	if (ioctl(s, HCIGETDEVINFO, (void *) &di)) return 0;
	mac_address mac;
	mac.bluetooth( di.bdaddr );
	address_vf vf = mac;
	set->add(vf);
	return 0;
}

void discover_bluetooth( endpoint_set& endpoints ) {
	hci_for_each_dev(HCI_UP, &dev_info, (long)&endpoints );
}

void discover_ip_addresses( endpoint_set& endpoints ) {
	struct ifaddrs* ifaceBuffer = NULL;
	struct ifaddrs* tmpAddr     = NULL;
	void*           tmpAddrPtr  = NULL;
	char            straddr     [INET_ADDRSTRLEN];

	int ret = getifaddrs( &ifaceBuffer );
	if( ret != 0 ) return;

	for( struct ifaddrs* i=ifaceBuffer; i != NULL; i=i->ifa_next ) {

		// ignore devices that are disabled or have no ip
		if(i == NULL) continue;
		struct sockaddr* addr = i->ifa_addr;

		// only look at IPv4, not IPv6 addresses
		if (addr->sa_family == AF_INET) {
			if (addr==NULL) continue;
			tmpAddrPtr= &((struct sockaddr_in*)addr)->sin_addr;
			inet_ntop( i->ifa_addr->sa_family, tmpAddrPtr, straddr, sizeof(straddr) );
			ip_address ip = straddr;
			if (ip.is_loopback()) continue;
			address_vf vf = ip;
			endpoints.add( vf );
		} else
		if (addr->sa_family == AF_INET6) {
			if (addr==NULL) continue;
			tmpAddrPtr= &((struct sockaddr_in6*)addr)->sin6_addr;
			inet_ntop( i->ifa_addr->sa_family, tmpAddrPtr, straddr, sizeof(straddr) );
			ip_address ip = straddr;
			if (ip.is_loopback()) continue;
			address_vf vf = ip;
			endpoints.add( vf );
		} else
		if (i->ifa_name[0]=='p' && i->ifa_name[1]=='a' && i->ifa_name[2]=='n') {
			mac_address mac = getMacFromIF(i->ifa_name);
			address_vf vf = mac;
//			endpoints.add( vf );
		}
	}
}

void discover_endpoints( endpoint_set& endpoints ) {
	discover_ip_addresses( endpoints );
	discover_bluetooth( endpoints );
}

#endif /* ADDRESSDISCOVERY_HPP_ */
