// [License]
// The Ariba-Underlay Copyright
//
// Copyright (c) 2008-2009, Institute of Telematics, Universität Karlsruhe (TH)
//
// Institute of Telematics
// Universität Karlsruhe (TH)
// Zirkel 2, 76128 Karlsruhe
// Germany
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
// 1. Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the
// documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE INSTITUTE OF TELEMATICS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE ARIBA PROJECT OR
// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
// PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
// LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
// NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// The views and conclusions contained in the software and documentation
// are those of the authors and should not be interpreted as representing
// official policies, either expressed or implied, of the Institute of
// Telematics.
// [License]

#ifndef LOGGING_H__
#define LOGGING_H__

#include <iostream>
#include <cstdlib>
#include <log4cxx/logger.h>
#include <log4cxx/basicconfigurator.h>

#ifndef PACKAGE
  #include "ariba/config.h"
#endif

#ifdef LOGCOLORS

  #define colorDefault { std::cout << "\033[0m";  } /*reset*/
  #define colorDebug   { std::cout << "\033[33m"; } /*cyan*/
  #define colorInfo    { std::cout << "\033[32m"; } /*green*/
  #define colorWarn    { std::cout << "\033[34m"; } /*blue*/
  #define colorError   { std::cout << "\033[31m"; } /*red*/

#else

  #define colorDefault { }
  #define colorDebug   { }
  #define colorInfo    { }
  #define colorWarn    { }
  #define colorError   { }

#endif // ENABLE_LOGCOLORS

#define use_logging_h(x) \
	private: static log4cxx::LoggerPtr logger;

#define use_logging_cpp(x) \
	log4cxx::LoggerPtr x::logger(log4cxx::Logger::getLogger(#x));

#ifdef HAVE_MAEMO

  #define logging_trace(x)  {                                                             }
  #define logging_debug(x)  {                                                             }
  #define logging_info(x)   {                                                             }
  #define logging_warn(x)   {colorWarn;  LOG4CXX_WARN(logger,x);  colorDefault;           }
  #define logging_error(x)  {colorError; LOG4CXX_ERROR(logger,x); colorDefault;           }
  #define logging_force(x)  {                                                             }
  #define logging_fatal(x)  {colorError; LOG4CXX_FATAL(logger,x); colorDefault; exit(-1); }

#else

  #define logging_trace(x)  {            LOG4CXX_TRACE(logger,x);                         }
  #define logging_debug(x)  {colorDebug; LOG4CXX_DEBUG(logger,x); colorDefault;           }
  #define logging_info(x)   {colorInfo;  LOG4CXX_INFO(logger,x);  colorDefault;           }
  #define logging_warn(x)   {colorWarn;  LOG4CXX_WARN(logger,x);  colorDefault;           }
  #define logging_error(x)  {colorError; LOG4CXX_ERROR(logger,x); colorDefault;           }
  #define logging_force(x)  {colorInfo;  LOG4CXX_INFO(logger,x);  colorDefault;           }
  #define logging_fatal(x)  {colorError; LOG4CXX_FATAL(logger,x); colorDefault; exit(-1); }

#endif // HAVE_MAEMO

#endif //LOGGING_H__
